Imports System.Windows.Forms
Imports System.Drawing
Imports System.ComponentModel

Public Class EffectsLabel
  Inherits Label

  Private FShadowColor As Color = Color.WhiteSmoke

  Private Const sDescription As String = _
                "Kolor ta, wykorzystywany do stworzenia efektu cienia."
  Private Const sCategory As String = "Appearance"

  <DescriptionAttribute(sDescription), Category(sCategory)> _
  Public Property ShadowColor() As Color
    Get
      Return FShadowColor
    End Get
    Set(ByVal Value As Color)
      If (Value.Equals(FShadowColor)) Then Exit Property
      FShadowColor = Value
      Invalidate()
    End Set
  End Property

  Private Function ShadowBrush() As Brush
    Return New SolidBrush(FShadowColor)
  End Function

  Protected Overrides Sub OnPaint( _
    ByVal e As PaintEventArgs)

    Dim Rect As New RectangleF(-2, -2, Width, Height)

    e.Graphics.DrawString(Text, Font, _
      ShadowBrush(), Rect, FormatObject())

    MyBase.OnPaint(e)

  End Sub

#Region " Ponisze funkcje s do monotonne. Zastp je lepszym algorytmem. "

  Private Function FormatObject() As StringFormat
    ' Uwaga: Nazwa funkcji wykorzystywana jest jako tymczasowa zmienna!
    FormatObject = New StringFormat()
    SetLineAlignment(FormatObject)
    SetAlignment(FormatObject)

    If (RightToLeft) Then
      FormatObject.FormatFlags = FormatObject.FormatFlags Or _
        StringFormatFlags.DirectionRightToLeft
    End If
  End Function

  Private Sub SetLineAlignment(ByVal FormatObject As StringFormat)
    Select Case TextAlign ' Koszmarny algorytm!
      Case ContentAlignment.BottomLeft To _
        ContentAlignment.BottomRight

        FormatObject.LineAlignment = StringAlignment.Far

      Case ContentAlignment.MiddleLeft To _
        ContentAlignment.MiddleRight

        FormatObject.LineAlignment = StringAlignment.Center

      Case ContentAlignment.TopLeft To _
        ContentAlignment.TopRight

        FormatObject.LineAlignment = StringAlignment.Near
    End Select
  End Sub

  Private Sub SetAlignment(ByVal FormatObject As StringFormat)
    Select Case TextAlign ' Koszmarny algorytm!
      Case ContentAlignment.BottomLeft, _
        ContentAlignment.TopLeft, _
        ContentAlignment.MiddleLeft

        FormatObject.Alignment = StringAlignment.Near

      Case ContentAlignment.MiddleCenter, _
        ContentAlignment.BottomCenter, _
        ContentAlignment.TopCenter

        FormatObject.Alignment = StringAlignment.Center

      Case ContentAlignment.TopRight, _
        ContentAlignment.BottomRight, _
        ContentAlignment.MiddleRight

        FormatObject.Alignment = StringAlignment.Far
    End Select
  End Sub

#End Region

End Class
